<?php
/**
* Auto detect language and currency
*
* NOTICE OF LICENSE
*
* This product is licensed for one customer to use on one installation (test stores and multishop included).
* Site developer has the right to modify this module to suit their needs, but can not redistribute the module in
* whole or in part. Any other use of this module constitues a violation of the user agreement.
*
* DISCLAIMER
*
* NO WARRANTIES OF DATA SAFETY OR MODULE SECURITY
* ARE EXPRESSED OR IMPLIED. USE THIS MODULE IN ACCORDANCE
* WITH YOUR MERCHANT AGREEMENT, KNOWING THAT VIOLATIONS OF
* PCI COMPLIANCY OR A DATA BREACH CAN COST THOUSANDS OF DOLLARS
* IN FINES AND DAMAGE A STORES REPUTATION. USE AT YOUR OWN RISK.
*
*  @author    idnovate
*  @copyright 2017 idnovate
*  @license   See above
*/

class AdminAutoLanguageCurrencyConfController extends ModuleAdminController
{
    protected $delete_mode;
    protected $_defaultOrderBy = 'position';
    protected $_defaultOrderWay = 'ASC';
    protected $can_add_conf = true;
    protected $top_elements_in_list = 4;
    protected $position_identifier = 'id_autolanguagecurrency_configuration';

    public function __construct()
    {
        $this->bootstrap = true;
        $this->table = 'autolanguagecurrency_configuration';
        $this->className = 'AutoLanguageCurrencyConfiguration';
        $this->tabClassName = 'AdminAutoLanguageCurrencyConf';
        $this->module_name = 'autolanguagecurrency';
        $this->name = 'autolanguagecurrency';
        $this->tab = 'front_office_features';

        parent::__construct();
        
        $this->addRowAction('edit');
        $this->addRowAction('delete');
        $this->_orderBy = $this->_defaultOrderBy;
        $this->_orderWay = $this->_defaultOrderWay;
        $this->show_toolbar = true;
        $this->allow_export = true;
        $this->identifier = 'id_autolanguagecurrency_configuration';
        if (version_compare(_PS_VERSION_, '1.6', '>=')) {
            $this->meta_title[] = $this->l('Auto language currency configuration');
        } else {
            $this->meta_title = $this->l('Auto language currency configuration');
        }
        $this->tpl_list_vars['title'] = $this->l('List of exceptions');

        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->l('Delete selected'),
                'confirm' => $this->l('Delete selected items?'),
                'icon' => 'icon-trash'
            )
        );

        $this->context = Context::getContext();

        $this->default_form_language = $this->context->language->id;

        $this->fields_list = array(
            'id_autolanguagecurrency_configuration' => array(
                'title' => $this->l('ID'),
                'align' => 'text-center',
                'class' => 'fixed-width-xs'
            ),
            'active' => array(
                'title' => $this->l('Enabled'),
                'align' => 'text-center',
                'active' => 'status',
                'type' => 'bool',
                'callback' => 'printActiveIcon'
            ),
            'countries' => array(
                'title' => $this->l('Country(s)'),
                'callback' => 'getConfigCountries',
                'align' => 'text-center'
            ),
            'zones' => array(
                'title' => $this->l('Zone(s)'),
                'callback' => 'getConfigZones',
                'align' => 'text-center'
            ),
            'language' => array(
                'title' => $this->l('Language to assing'),
                'callback' => 'getConfigLanguage',
                'align' => 'text-center'
            ),
            'currency' => array(
                'title' => $this->l('Currency to assign'),
                'callback' => 'getConfigCurrency',
                'align' => 'text-center'
            ),
            'hide_language_selector' => array(
                'title' => $this->l('Hide language'),
                'type' => 'bool',
                'callback' => 'printLanguageSelectorIcon',
                'align' => 'text-center'
            ),
            'hide_currency_selector' => array(
                'title' => $this->l('Hide currency'),
                'type' => 'bool',
                'callback' => 'printCurrencySelectorIcon',
                'align' => 'text-center'
            ),
            'catalog_mode' => array(
                'title' => $this->l('Catalog mode'),
                'align' => 'text-center',
                'type' => 'bool',
                'callback' => 'printCatalogModeIcon'
            ),
            'redirect_shop' => array(
                'title' => $this->l('Redirect to shop'),
                'callback' => 'getConfigShop',
                'align' => 'text-center'
            ),
            'redirect_url' => array(
                'title' => $this->l('Redirect to URL'),
                'align' => 'text-center'
            ),
            'position' => array('title' => $this->l('Position'), 'filter_key' => 'position', 'align' => 'center', 'class' => 'fixed-width-sm', 'position' => 'position'),
            /*
            'date_add' => array(
                'title' => $this->l('Added'),
                'align' => 'text-center'
            ),
            */
            'date_upd' => array(
                'title' => $this->l('Modified'),
                'align' => 'text-center'
            ),
        );

        $this->shopLinkType = 'shop';

        if (Shop::isFeatureActive() && Shop::getContext() != Shop::CONTEXT_SHOP) {
            unset($this->fields_list['position']);
        }

        if (!$this->module->active) {
            Tools::redirectAdmin($this->context->link->getAdminLink('AdminHome'));
        }

        if (Shop::isFeatureActive() && (Shop::getContext() == Shop::CONTEXT_ALL || Shop::getContext() == Shop::CONTEXT_GROUP)) {
            $this->can_add_conf = false;
        }
    }

    public function initContent()
    {
        if ($this->action == 'select_delete') {
            $this->context->smarty->assign(array(
                'delete_form' => true,
                'url_delete' => htmlentities($_SERVER['REQUEST_URI']),
                'boxes' => $this->boxes,
            ));
        }
        if (!$this->can_add_conf && !$this->display) {
            $this->informations[] = $this->l('You have to select a shop if you want to create a new exception.');
        }

        parent::initContent();

        if (Tools::getValue('action') == 'updatePositions') {
            $this->_updatePositions(Tools::getValue('autolanguagecurrency_configuration'));
        }

        if (version_compare(_PS_VERSION_, '1.6', '>=')) {
            $module = new AutoLanguageCurrency();
            $this->context->smarty->assign(array(
                'this_path'  => '../modules/'.$module->name.'/',
                'support_id' => $module->addons_id_product,
            ));
            $available_iso_codes = array('en', 'es');
            $default_iso_code = 'en';
            $template_iso_suffix = in_array($this->context->language->iso_code, $available_iso_codes) ? $this->context->language->iso_code : $default_iso_code;
            $this->content .= $this->context->smarty->fetch(_PS_MODULE_DIR_.'/'.$module->name.'/views/templates/admin/company/information_'.$template_iso_suffix.'.tpl');
        }
        $this->context->smarty->assign(array(
            'content' => $this->content,
        ));
    }

    public function init()
    {
        parent::init();
        parent::initBreadcrumbs(Tab::getIdFromClassName('AutoLanguageCurrencyConfiguration'));
    }

    public function initToolbar()
    {
        parent::initToolbar();

        if (!$this->can_add_conf) {
            unset($this->toolbar_btn['new']);
        }
    }

    public function getList($id_lang, $orderBy = null, $orderWay = null, $start = 0, $limit = null, $id_lang_shop = null)
    {
        parent::getList($id_lang, $orderBy, $orderWay, $start, $limit, $id_lang_shop);
    }


    public function initToolbarTitle()
    {
        parent::initToolbarTitle();
        switch ($this->display) {
            case '':
            case 'list':
                array_pop($this->toolbar_title);
                $this->toolbar_title[] = $this->l('Manage Auto Language Currency Configuration');
                break;
            case 'view':
                if (($conf = $this->loadObject(true)) && Validate::isLoadedObject($conf)) {
                    array_pop($this->toolbar_title);
                    $this->toolbar_title[] = sprintf($this->l('Exception: %s'), $conf->id_autolanguagecurrency_configuration);
                }
                break;
            case 'add':
            case 'edit':
                array_pop($this->toolbar_title);
                if (($conf = $this->loadObject(true)) && Validate::isLoadedObject($conf)) {
                    $this->toolbar_title[] = sprintf($this->l('Editing exception: %s'), $conf->id_autolanguagecurrency_configuration);
                } else {
                    $this->toolbar_title[] = $this->l('Creating a new language / currency exception');
                }
                break;
        }
    }

    public function initPageHeaderToolbar()
    {
        parent::initPageHeaderToolbar();

        if (empty($this->display)) {
            $this->page_header_toolbar_btn['desc-module-back'] = array(
                'href' => 'index.php?controller=AdminModules&token='.Tools::getAdminTokenLite('AdminModules'),
                'desc' => $this->l('Back'),
                'icon' => 'process-icon-back'
            );
            /*
            $this->page_header_toolbar_btn['desc-module-new'] = array(
                'href' => 'index.php?controller='.$this->tabClassName.'&add'.$this->table.'&token='.Tools::getAdminTokenLite($this->tabClassName),
                'desc' => $this->l('New'),
                'icon' => 'process-icon-new'
            );
            */
            $this->page_header_toolbar_btn['desc-module-reload'] = array(
                'href' => 'index.php?controller='.$this->tabClassName.'&token='.Tools::getAdminTokenLite($this->tabClassName).'&reload=1',
                'desc' => $this->l('Reload'),
                'icon' => 'process-icon-refresh'
            );
            $this->page_header_toolbar_btn['desc-module-translate'] = array(
                'href' => '#',
                'desc' => $this->l('Translate'),
                'modal_target' => '#moduleTradLangSelect',
                'icon' => 'process-icon-flag'
            );
            $this->page_header_toolbar_btn['desc-module-hook'] = array(
                'href' => 'index.php?tab=AdminModulesPositions&token='.Tools::getAdminTokenLite('AdminModulesPositions').'&show_modules='.Module::getModuleIdByName($this->module_name),
                'desc' => $this->l('Manage hooks'),
                'icon' => 'process-icon-anchor'
            );
        }

        if (!$this->can_add_conf) {
            unset($this->page_header_toolbar_btn['desc-module-new']);
        }
    }

    public function initModal()
    {
        parent::initModal();

        $languages = Language::getLanguages(false);
        $translateLinks = array();

        if (version_compare(_PS_VERSION_, '1.7.2', '>=')) {
            $module = Module::getInstanceByName($this->module_name);
            $isNewTranslateSystem = $module->isUsingNewTranslationSystem();
            $link = Context::getContext()->link;
            foreach ($languages as $lang) {
                if ($isNewTranslateSystem) {
                    $translateLinks[$lang['iso_code']] = $link->getAdminLink('AdminTranslationSf', true, array(
                        'lang' => $lang['iso_code'],
                        'type' => 'modules',
                        'selected' => $module->name,
                        'locale' => $lang['locale'],
                    ));
                } else {
                    $translateLinks[$lang['iso_code']] = $link->getAdminLink('AdminTranslations', true, array(), array(
                        'type' => 'modules',
                        'module' => $module->name,
                        'lang' => $lang['iso_code'],
                    ));
                }
            }
        }

        $this->context->smarty->assign(array(
            'trad_link' => 'index.php?tab=AdminTranslations&token='.Tools::getAdminTokenLite('AdminTranslations').'&type=modules&module='.$this->module_name.'&lang=',
            'module_languages' => $languages,
            'module_name' => $this->module_name,
            'translateLinks' => $translateLinks,
        ));

        $modal_content = $this->context->smarty->fetch('controllers/modules/modal_translation.tpl');

        $this->modals[] = array(
            'modal_id' => 'moduleTradLangSelect',
            'modal_class' => 'modal-sm',
            'modal_title' => $this->l('Translate this module'),
            'modal_content' => $modal_content
        );
    }

    public function initProcess()
    {
        parent::initProcess();

        if (Tools::getIsset('reload')) {
            $this->action = 'reset_filters';
        }

        if (Tools::isSubmit('changeActiveVal') && $this->id_object) {
            if ($this->tabAccess['edit'] === '1') {
                $this->action = 'change_active_val';
            } else {
                $this->errors[] = Tools::displayError('You do not have permission to edit this.');
            }
        }

        if (Tools::isSubmit('changeCatalogModeVal') && $this->id_object) {
            if ($this->tabAccess['edit'] === '1') {
                $this->action = 'change_catalog_mode_val';
            } else {
                $this->errors[] = Tools::displayError('You do not have permission to edit this.');
            }
        }
    }

    public function renderList()
    {
        if ((Tools::isSubmit('submitBulkdelete'.$this->table) || Tools::isSubmit('delete'.$this->table)) && $this->tabAccess['delete'] === '1') {
            $this->tpl_list_vars = array(
                'delete_conf' => true,
                'REQUEST_URI' => $_SERVER['REQUEST_URI'],
                'POST' => $_POST
            );
        }

        if (Tools::getValue('save') == 'ok') {
            $this->content .= $this->module->displayConfirmation($this->l('Configuration saved successfully.'));
        } elseif (Tools::getValue('save') == 'nok') {
            $this->content .= $this->module->displayError($this->l('Something went wrong. Please, try again.'));
        }

        $this->content .= $this->renderGeneralConfigForm();

        return parent::renderList();
    }

    protected function renderGeneralConfigForm()
    {
        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->module = new AutoLanguageCurrency();
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitAutoLanguageCurrencyModule';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false)
            .'&configure='.$this->module_name.'&tab_module='.$this->tab.'&module_name='.$this->module_name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = array(
            'fields_value' => AutoLanguageCurrency::getGeneralConfigFormValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );

        return $helper->generateForm(array($this->getGeneralConfigForm()));
    }

    protected function getGeneralConfigForm()
    {
        return array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('General settings'),
                    'icon' => 'icon-cogs',
                 ),
                'input' => array(
                    array(
                        'col' => 3,
                        'type' => (version_compare(_PS_VERSION_, '1.6', '>=')) ? 'switch' : 'radio',
                        'name' => 'AUTOCURRLANG_ENABLED',
                        'label' => $this->l('Enabled'),
                        'class' => 't',
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => true,
                                'label' => $this->l('Yes')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => false,
                                'label' => $this->l('No')
                            )
                        ),
                    ),
                    array(
                        'col' => 3,
                        'type' => (version_compare(_PS_VERSION_, '1.6', '>=')) ? 'switch' : 'radio',
                        'name' => 'AUTOCURRENCY_ENABLED',
                        'label' => $this->l('Auto change currency enabled'),
                        'class' => 't',
                        'values' => array(
                            array(
                                'id' => 'autocurrency_on',
                                'value' => true,
                                'label' => $this->l('Yes')
                            ),
                            array(
                                'id' => 'autocurrency_off',
                                'value' => false,
                                'label' => $this->l('No')
                            )
                        ),
                    ),
                    array(
                        'col' => 3,
                        'type' => (version_compare(_PS_VERSION_, '1.6', '>=')) ? 'switch' : 'radio',
                        'name' => 'AUTOLANGUAGE_ENABLED',
                        'label' => $this->l('Auto change language enabled'),
                        'class' => 't',
                        'values' => array(
                            array(
                                'id' => 'autolanguage_on',
                                'value' => true,
                                'label' => $this->l('Yes')
                            ),
                            array(
                                'id' => 'autolanguage_off',
                                'value' => false,
                                'label' => $this->l('No')
                            )
                        ),
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Default currency'),
                        'name' => 'AUTOCURRENCY_DEFAULT',
                        'required' => true,
                        'col' => '5',
                        'class' => 'fixed-width-md',
                        'options' => array(
                            'query' => Currency::getCurrencies(),
                            'id' => 'id_currency',
                            'name' => 'name'
                        ),
                        'hint' => $this->l('Default currency to change if the currency of the visitor is not installed')
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Default language'),
                        'name' => 'AUTOLANGUAGE_DEFAULT',
                        'required' => true,
                        'col' => '5',
                        'class' => 'fixed-width-md',
                        'options' => array(
                            'query' => Language::getLanguages(false),
                            'id' => 'id_lang',
                            'name' => 'name'
                        ),
                        'hint' => $this->l('Default language to change if the language of the visitor is not installed')
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Hide currency selector'),
                        'name' => 'AUTOCURRENCY_SELECTOR',
                        'lang' => false,
                        'col' => '3',
                        'hint' => $this->l('This configuration overrides the same at any exception'),
                        'desc' => $this->l('Define selector class or id of the currency selector to hide it (e.g.: #currencies-block-top). Leave blank to do nothing.')
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Hide language selector'),
                        'name' => 'AUTOLANGUAGE_SELECTOR',
                        'lang' => false,
                        'col' => '3',
                        'hint' => $this->l('This configuration overrides the same at any exception'),
                        'desc' => $this->l('Define selector class or id of the language selector to hide it (e.g.: #languages-block-top). Leave blank to do nothing.')
                    ),
                    array(
                        'col' => 3,
                        'type' => (version_compare(_PS_VERSION_, '1.6', '>=')) ? 'switch' : 'radio',
                        'name' => 'IGNORE_BOTS',
                        'label' => $this->l('Ignore bots'),
                        'class' => 't',
                        'values' => array(
                            array(
                                'id' => 'ignore_bots_on',
                                'value' => true,
                                'label' => $this->l('Yes')
                            ),
                            array(
                                'id' => 'ignore_bots_off',
                                'value' => false,
                                'label' => $this->l('No')
                            )
                        ),
                    ),
                    array(
                        'col' => 5,
                        'type' => (version_compare(_PS_VERSION_, '1.6', '>=')) ? 'switch' : 'radio',
                        'name' => 'AUTOCURRLANG_LOG',
                        'label' => $this->l('Log'),
                        'class' => 't',
                        'desc' => $this->l('Write log with the visits and the language and currency assigned.').' <a href="'.__PS_BASE_URI__.'modules/autolanguagecurrency/log.html" target="_blank">'.$this->l('Open').'</a>',
                        'values' => array(
                            array(
                                'id' => 'log_on',
                                'value' => true,
                                'label' => $this->l('Yes')
                            ),
                            array(
                                'id' => 'log_off',
                                'value' => false,
                                'label' => $this->l('No')
                            )
                        ),
                    ),
                ),
                'submit' => array(
                    'title' => $this->l('Save'),
                    'type' => 'submit',
                    'class' => (version_compare(_PS_VERSION_, '1.6', '>=')) ? 'btn btn-default pull-right' : 'button big',
                    'name' => 'submitAutoLanguageCurrencyModule',
                ),
            ),
        );
    }

    public function renderOptions()
    {
        return parent::renderOptions();
    }

    public function renderForm()
    {
        if (!($conf = $this->loadObject(true))) {
            return;
        }

        $zones = array(array('id_zone' => 'all', 'name' => $this->l('-- All --')));
        $countries = array(array('iso_code' => 'all', 'name' => $this->l('-- All --')));
        $countries = array_merge($countries, Country::getCountries((int)($this->context->language->id)));
        $shops = array(array('id_shop' => '', 'name' => ''));
        $shops = array_merge($shops, Shop::getShops());

        $this->fields_form = array(
            'legend' => array(
                'title' => $this->l('Auto Language And Currency Exception Configuration'),
                'icon' => 'icon-key'
            ),
            'input' => array(
                array(
                    'type' => (version_compare(_PS_VERSION_, '1.6', '>=')) ? 'switch' : 'radio',
                    'label' => $this->l('Active'),
                    'name' => 'active',
                    'class' => 't',
                    'col' => '1',
                    'is_bool' => true,
                    'values' => array(
                        array(
                            'id' => 'active_on',
                            'value' => 1,
                            'label' => $this->l('Enabled')
                        ),
                        array(
                            'id' => 'active_off',
                            'value' => 0,
                            'label' => $this->l('Disabled')
                        )
                    ),
                    'hint' => $this->l('Enable or disable this exception')
                ),
                array(
                    'type' => 'select',
                    'label' => $this->l('Country(s)'),
                    'name' => 'countries[]',
                    'multiple' => true,
                    'col' => '5',
                    'class' => 'fixed-width-md',
                    'options' => array(
                        'query' => $countries,
                        'id' => 'iso_code',
                        'name' => 'name'
                    ),
                    'hint' => $this->l('Country(s) for exception')
                ),
                array(
                    'type' => 'select',
                    'label' => $this->l('Zone(s)'),
                    'name' => 'zones[]',
                    'multiple' => true,
                    'col' => '5',
                    'class' => 'fixed-width-md',
                    'options' => array(
                        'query' => array_merge($zones, Zone::getZones()),
                        'id' => 'id_zone',
                        'name' => 'name'
                    ),
                    'hint' => $this->l('Zone(s) for exception')
                ),
                array(
                    'type' => 'select',
                    'label' => $this->l('Language to assign'),
                    'name' => 'language',
                    'required' => true,
                    'col' => '5',
                    'class' => 'fixed-width-md',
                    'options' => array(
                        'query' => Language::getLanguages(false),
                        'id' => 'id_lang',
                        'name' => 'name'
                    ),
                    'hint' => $this->l('Language assigned for this exception')
                ),
                array(
                    'type' => 'select',
                    'label' => $this->l('Currency to assign'),
                    'name' => 'currency',
                    'required' => true,
                    'col' => '5',
                    'class' => 'fixed-width-md',
                    'options' => array(
                        'query' => Currency::getCurrencies(),
                        'id' => 'id_currency',
                        'name' => 'name'
                    ),
                    'hint' => $this->l('Currency assigned for this exception')
                ),
                array(
                    'type' => 'text',
                    'label' => $this->l('Hide language selector'),
                    'name' => 'hide_language_selector',
                    'lang' => false,
                    'col' => '3',
                    'desc' => $this->l('Define selector class or id of the language selector to hide it. Leave blank to do nothing.')
                ),
                array(
                    'type' => 'text',
                    'label' => $this->l('Hide currency selector'),
                    'name' => 'hide_currency_selector',
                    'lang' => false,
                    'col' => '3',
                    'desc' => $this->l('Define selector class or id of the currency selector to hide it. Leave blank to do nothing.')
                ),
                array(
                    'type' => 'hidden',
                    'name' => 'position'
                ),
            )
        );

        if (Shop::isFeatureActive()) {
            $this->fields_form['input'][] = array(
                'type' => 'select',
                'label' => $this->l('Redirect to Shop'),
                'name' => 'redirect_shop',
                'multiple' => false,
                'col' => '5',
                'class' => 'fixed-width-md',
                'options' => array(
                    'query' => $shops,
                    'id' => 'id_shop',
                    'name' => 'name'
                ),
                'desc' => $this->l('Force redirection to this Shop (leave blank to disable redirection).')
            );
        }

        $this->fields_form['input'][] = array(
            'type' => 'text',
            'label' => $this->l('Redirect to URL'),
            'name' => 'redirect_url',
            'lang' => false,
            'col' => '3',
            'desc' => $this->l('Force redirection to this URL (leave blank to disable redirection).')
        );

        $this->fields_form['input'][] = array(
            'type' => (version_compare(_PS_VERSION_, '1.6', '>=')) ? 'switch' : 'radio',
            'label' => $this->l('Catalog mode'),
            'name' => 'catalog_mode',
            'class' => 't',
            'col' => '1',
            'is_bool' => true,
            'values' => array(
                array(
                    'id' => 'catalog_mode_on',
                    'value' => 1,
                    'label' => $this->l('Enabled')
                ),
                array(
                    'id' => 'catalog_mode_off',
                    'value' => 0,
                    'label' => $this->l('Disabled')
                )
            ),
            'hint' => $this->l('This option sets catalog mode store for this exception')
        );

        $this->fields_form['submit'] = array(
            'title' => $this->l('Save'),
        );

        //Load db values for select inputs
        if ($conf->id) {
            $zones_db = explode(';', $conf->zones);
            $countries_db = explode(';', $conf->countries);
            $this->fields_value = array(
                'zones[]' => $zones_db,
                'countries[]' => $countries_db
            );
        }

        return parent::renderForm();
    }

    public function renderView()
    {
        return parent::renderView();
    }

    public function processDelete()
    {
        parent::processDelete();
    }

    protected function processBulkDelete()
    {
        parent::processBulkDelete();
    }

    public function processAdd()
    {
        if (Tools::getValue('submitFormAjax')) {
            $this->redirect_after = false;
        }
        if ($this->_formValidations()) {
            $_POST['countries'] = (is_array(Tools::getValue('countries')) ? (in_array('all', Tools::getValue('countries')) ? 'all' : implode(';', Tools::getValue('countries'))) : (Tools::getValue('countries') == '' ? '' : Tools::getValue('countries')));
            $_POST['zones'] = (is_array(Tools::getValue('zones')) ? (in_array('all', Tools::getValue('zones')) ? 'all' : implode(';', Tools::getValue('zones'))) : (Tools::getValue('zones') == '' ? '' : Tools::getValue('zones')));
        } else {
            $this->errors[] = Tools::displayError('An error occurred while trying to save new exception.');
        }
        return parent::processAdd();
    }

    public function processUpdate()
    {
        if (Validate::isLoadedObject($this->object)) {
            $this->_formValidations();
            $_POST['countries'] = (is_array(Tools::getValue('countries')) ? (in_array('all', Tools::getValue('countries')) ? 'all' : implode(';', Tools::getValue('countries'))) : (Tools::getValue('countries') == '' ? '' : Tools::getValue('countries')));
            $_POST['zones'] = (is_array(Tools::getValue('zones')) ? (in_array('all', Tools::getValue('zones')) ? 'all' : implode(';', Tools::getValue('zones'))) : (Tools::getValue('zones') == '' ? '' : Tools::getValue('zones')));
            return parent::processUpdate();
        } else {
            $this->errors[] = Tools::displayError('An error occurred while loading the object.').'
                <b>'.$this->table.'</b> '.Tools::displayError('(cannot load object)');
        }
    }

    public function postProcess()
    {
        return parent::postProcess();
    }

    public function processSave()
    {
        return parent::processSave();
    }

    protected function afterAdd($object)
    {
        $id_autolanguagecurrency_configuration = Tools::getValue('id_autolanguagecurrency_configuration');
        $this->afterUpdate($object, $id_autolanguagecurrency_configuration);
        return true;
    }

    protected function afterUpdate($object, $id_autolanguagecurrency_configuration = false)
    {
        if ($id_autolanguagecurrency_configuration) {
            $conf = new AutoLanguageCurrencyConfiguration((int)$id_autolanguagecurrency_configuration);
        } else {
            $conf = new AutoLanguageCurrencyConfiguration((int)$object->id_autolanguagecurrency_configuration);
        }

        if (Validate::isLoadedObject($conf)) {
            $conf->save();
        }
        return true;
    }

    /**
     * Toggle active flag
     */
    public function processChangeActiveVal()
    {
        $conf = new AutoLanguageCurrencyConfiguration($this->id_object);

        if (!Validate::isLoadedObject($conf)) {
            $this->errors[] = Tools::displayError('An error occurred while updating exception information.');
        }
        $conf->active = $conf->active ? 0 : 1;
        if (!$conf->update()) {
            $this->errors[] = Tools::displayError('An error occurred while updating exception information.');
        }
        Tools::redirectAdmin(self::$currentIndex.'&token='.$this->token);
    }

    public function processChangeCatalogModeVal()
    {
        $conf = new AutoLanguageCurrencyConfiguration($this->id_object);

        if (!Validate::isLoadedObject($conf)) {
            $this->errors[] = Tools::displayError('An error occurred while updating exception information.');
        }
        $conf->catalog_mode = $conf->catalog_mode ? 0 : 1;
        if (!$conf->update()) {
            $this->errors[] = Tools::displayError('An error occurred while updating exception information.');
        } else {
            $this->informations[] = $this->l('Catalog mode changed successfully.');
        }
        Tools::redirectAdmin(self::$currentIndex.'&token='.$this->token);
    }

    public function printActiveIcon($value, $conf)
    {
        return '<a class="list-action-enable '.($value ? 'action-enabled' : 'action-disabled').'" href="index.php?'.htmlspecialchars('tab=AdminAutoLanguageCurrencyConf&id_autolanguagecurrency_configuration='.(int)$conf['id_autolanguagecurrency_configuration'].'&changeActiveVal&token='.Tools::getAdminTokenLite('AdminAutoLanguageCurrencyConf')).'">'.($value ? '<i class="icon-check"></i>' : '<i class="icon-remove"></i>').'</a>';
    }

    public function printCatalogModeIcon($value, $conf)
    {
        return '<a class="list-action-enable '.($value ? 'action-enabled' : 'action-disabled').'" href="index.php?'.htmlspecialchars('tab=AdminAutoLanguageCurrencyConf&id_autolanguagecurrency_configuration='.(int)$conf['id_autolanguagecurrency_configuration'].'&changeCatalogModeVal&token='.Tools::getAdminTokenLite('AdminAutoLanguageCurrencyConf')).'">'.($value ? '<i class="icon-check"></i>' : '<i class="icon-remove"></i>').'</a>';
    }

    public function printCurrencySelectorIcon($value)
    {
        return ($value ? '<i class="icon-check"></i>' : '<i class="icon-remove"></i>');
    }

    public function printLanguageSelectorIcon($value)
    {
        return ($value ? '<i class="icon-check"></i>' : '<i class="icon-remove"></i>');
    }

    /**
     * @param string $token
     * @param int $id
     * @param string $name
     * @return mixed
     */
    public function displayDeleteLink($token = null, $id = 0, $name = null)
    {
        $tpl = $this->createTemplate('helpers/list/list_action_delete.tpl');
        $tpl->assign(array(
            'href' => self::$currentIndex.'&'.$this->identifier.'='.$id.'&delete'.$this->table.'&token='.($token != null ? $token : $this->token),
            'confirm' => $this->l('Delete the selected item? ').$name,
            'action' => $this->l('Delete'),
            'id' => $id,
        ));

        return $tpl->fetch();
    }

    public function getConfigCountries($ids_countries)
    {
        if ($ids_countries === '') {
            return '--';
        } elseif ($ids_countries === 'all') {
            return $this->l('All');
        }
        $countries = array();
        $countries_array = explode(';', $ids_countries);
        foreach ($countries_array as $key => $country) {
            if ($key == $this->top_elements_in_list) {
                $countries[] = $this->l('...and more');
                break;
            }
            $country_id = Country::getByIso($country);
            $country = new Country((int)$country_id, $this->context->language->id);
            $countries[] = $country->name;
        }
        return implode('<br />', $countries);
    }

    public function getConfigZones($ids_zones)
    {
        if ($ids_zones === '') {
            return '--';
        } elseif ($ids_zones === 'all') {
            return $this->l('All');
        }
        $zones = array();
        $zones_array = explode(';', $ids_zones);
        foreach ($zones_array as $key => $zone) {
            if ($key == $this->top_elements_in_list) {
                $zones[] = $this->l('...and more');
                break;
            }
            $zone = new Zone((int)$zone);
            $zones[] = $zone->name;
        }
        return implode('<br />', $zones);
    }

    public function getConfigShop($id_shop)
    {
        if (!$id_shop || $id_shop == '') {
            return '--';
        }
        $shop = new Shop($id_shop);
        return $shop->name;
    }

    public function getConfigLanguage($id_language)
    {
        $language = new Language($id_language, $this->context->language->id);
        return $language->name;
    }

    public function getConfigCurrency($id_currency)
    {
        $currency = new Currency($id_currency);
        return $currency->name;
    }

    private function _createTemplate($tpl_name)
    {
        if ($this->override_folder) {
            if ($this->context->controller instanceof ModuleAdminController) {
                $override_tpl_path = $this->context->controller->getTemplatePath().$tpl_name;
            } elseif ($this->module) {
                $override_tpl_path = _PS_MODULE_DIR_.$this->module_name.'/views/templates/admin/'.$tpl_name;
            } else {
                if (file_exists($this->context->smarty->getTemplateDir(1).DIRECTORY_SEPARATOR.$this->override_folder.$this->base_folder.$tpl_name)) {
                    $override_tpl_path = $this->context->smarty->getTemplateDir(1).DIRECTORY_SEPARATOR.$this->override_folder.$this->base_folder.$tpl_name;
                } elseif (file_exists($this->context->smarty->getTemplateDir(0).DIRECTORY_SEPARATOR.'controllers'.DIRECTORY_SEPARATOR.$this->override_folder.$this->base_folder.$tpl_name)) {
                    $override_tpl_path = $this->context->smarty->getTemplateDir(0).'controllers'.DIRECTORY_SEPARATOR.$this->override_folder.$this->base_folder.$tpl_name;
                }
            }
        } else if ($this->module) {
            $override_tpl_path = _PS_MODULE_DIR_.$this->module_name.'/views/templates/admin/'.$tpl_name;
        }
        if (isset($override_tpl_path) && file_exists($override_tpl_path)) {
            return $this->context->smarty->createTemplate($override_tpl_path, $this->context->smarty);
        } else {
            return $this->context->smarty->createTemplate($tpl_name, $this->context->smarty);
        }
    }

    private function _updatePositions($positions)
    {
        foreach ($positions as $key => $position) {
            $pos = explode('_', $position);
            Db::getInstance()->execute('
                UPDATE `'.pSQL(_DB_PREFIX_.$this->name).'_configuration`
                SET `position` = '.(int)$key.'
                WHERE `id_autolanguagecurrency_configuration` = '.(int)$pos[2]);
        }
        return true;
    }

    private function _formValidations()
    {
        /*
        if (Tools::getValue('countries') == '') {
            $this->validateRules();
            $this->errors[] = Tools::displayError($this->l('Field \'Country(s)\' can not be empty.'));
            $this->display = 'edit';
        }
        if (Tools::getValue('zones') == '') {
            $this->validateRules();
            $this->errors[] = Tools::displayError($this->l('Field \'Zone(s)\' can not be empty.'));
            $this->display = 'edit';
        }
        */
        if (Tools::getValue('language') == '') {
            $this->validateRules();
            $this->errors[] = Tools::displayError($this->l('Field \'Language assigned\' can not be empty.'));
            $this->display = 'edit';
        }
        if (Tools::getValue('currency') == '') {
            $this->validateRules();
            $this->errors[] = Tools::displayError($this->l('Field \'Currency assigned\' can not be empty.'));
            $this->display = 'edit';
        }
        if (count($this->errors) == 0) {
            return true;
        }
    }
}
